/*
	Month Calendar - A Monthly Calendar with Week Numbers
	Copyright © 2005-2008 Harry Whitfield

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License as
	published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this program; if not, write to the Free
	Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
	MA  02110-1301  USA
	
	Month Calendar - version 2.5
	10 May, 2008
	Copyright © 2005-2008 Harry Whitfield
	mailto:g6auc@arrl.net
*/

	// global
	
	var gISOdate = "";
	var accessMode;
	
	var maxTooltipMemoLines = 30;

	filesystem.changeMode = function(path, mode)
	{
		if (systemPlatform == "macintosh") { return runCommand("chmod " + mode + " " + escapePath(path)) === ""; }
		return undefined;
	};

	function onMultiClicked(isoDate)
	{
		eprint('onMultiClicked:isoDate=' + isoDate);
		
		if (system.event.altKey)
		{
			if (memo_info.visible) { beep(); alert('Please close the memo window first.'); return; }	// openMemoWindow(isoDate); 
			colorSelect(isoDate);
			return;
		}
		
		if (system.event.shiftKey)
		{
			if (memo_info.visible) { beep(); alert('Please close the memo window first.'); return; }	// openMemoWindow(isoDate); 
			alarmSelect(isoDate);
			return;
		}
		
		openMemoWindow(isoDate);
	}


	function onDragDropped(isoDate)
	{
		var data = dragDropped();
		if (data !== "")
		{
			openMemoWindow(isoDate);
			memo.data += data;
		}
		
		if (gSoundFlag && (!memo_info.visible))
		{
			alarmSelect(isoDate);
			focusWidget();
		}
	}

	function openMemoWindow(isoDate)
	{
		eprint('openMemoWindow:isoDate=' + isoDate);
		
		gISOdate = isoDate;
		
		if (isoDate == "19700101")
		{
			memoTitle = "To Do List";
			memo.tooltip = "";
			if (preferences.speakDatesPref.value == "1") { speak("Opening Two-Do List"); }
		}
		else
		{
			var len   = isoDate.length;
			var year  = parseInt(isoDate.substring(0,       len - 4), 10);
			var month = parseInt(isoDate.substring(len - 4, len - 2), 10);
			var day   = parseInt(isoDate.substring(len - 2         ), 10);

			if (preferences.speakDatesPref.value == "1") { speakDate(year, month, day); }

			var d = new Date(year, month - 1, day);
			memoTitle = "Memorandum: " + d.toDateString();
			memo.tooltip = sunRiseSet(isoDate);
		}

		var sWidth = stringWidth(memoTitle, "Futura Medium", "", 9);
        var bWidth = 2*halfWidth - 142;
        if (sWidth <= bWidth)
        {
			status.data = statusShadow.data = memoTitle;
		}
		else
		{
			status.data = statusShadow.data = "";
		}

		memo.data = getMemo(isoDate);
		memo_info.visible = true;
		memo_info.focus();
		memo.focus();
		memo.select(-1, -1);
	}

	function saveMemoWindow()
	{
		saveMemo(gISOdate, memo.data);
		memo_info.visible = false;
		updateCalendar();			// was updateDate(false);
		updateMemos();
		main_window.focus();
		focusWidget();
	}

	function closeMemoWindow()
	{
		memo_info.visible = false;
		main_window.focus();
		focusWidget();
	}
	
	function makeISODate3(year, month, day)
	{
		var sYear  = String(year);
		var sMonth = String(month);
		var sDay   = String(day);
		while (sYear.length < 4) { sYear  = "0" + sYear;  }
		if (sMonth.length  == 1) { sMonth = "0" + sMonth; }
		if (sDay.length    == 1) { sDay   = "0" + sDay;   }
		return sYear + sMonth + sDay;
	}

	function hasMemo(isoDate)
	{
		var path = memoFolderPath + "/Memo-" + isoDate + ".txt";
		return filesystem.itemExists(path);
	}

	function getMemo(isoDate)
	{
		//eprint('getMemo:isoDate=' + isoDate);
		
		var path = memoFolderPath + "/Memo-" + isoDate + ".txt";
		
		//eprint('getMemo:path=' + path);
		
		if (filesystem.itemExists(path))
		{
			//eprint('getMemo: Memo for ' + isoDate + ' exists.');
			return filesystem.readFile(path).replace(/\r\n?/g, "\n");
		}
		else
		{
			//eprint('getMemo: No memo for ' + isoDate + '.');
			//return "Type your memo here ...";
			return "";
		}
	}
	
	function escapePath(s) { return s.replace(/([\W])/g,"\\$1"); }

	function getMemoLines(isoDate, count)	// return count non-blank lines from first maxTooltipMemoLines (30) excluding commands
	{
		if (count === 0) { return ""; }

		var data, lines, n, theLines, i;
		var path = memoFolderPath + "/Memo-" + isoDate + ".txt";
		if (filesystem.itemExists(path))
		{
			data = filesystem.readFile(path).replace(/\r\n?/g, "\n");
			lines = data.split('\n', maxTooltipMemoLines).join('\n').replace(/\<\<\w*\=[^\;\n\<\>]*?(\;\w*\=[^\;\n\<\>]*?)*\>\>\n?/g, "").split('\n');
			n = 0;
			theLines = [];
			for (i = 0; i < lines.length; i += 1)
			{
				if (lines[i] !== "") { theLines[n] = lines[i]; n += 1; }
				if (n == count) { return theLines.join('\n'); }
			}
			if (theLines.length > 0) { return theLines.join('\n'); } else { return ""; }
		}
		else { return ""; }
	}
	
	function saveMemo(isoDate, data)
	{
		eprint('saveMemo:isoDate=' + isoDate);
		
		var path = memoFolderPath + "/Memo-" + isoDate + ".txt";
		
		eprint('saveMemo:path=' + path);
		
		if (data !== "") 	// && (data != "Type your memo here ..."))
		{
			eprint('saveMemo: Writing memo for ' + isoDate + '.');
			filesystem.writeFile(path, data.replace(/\r\n?|\n/g, "\r\n"));
		}
		else if (filesystem.itemExists(path))
		{
			eprint('saveMemo: Deleting memo for ' + isoDate + '.');
			filesystem.remove(path);
		}
	}
	
	function memoKeyPress()
	{
  		var keyString = system.event.keyString;
  		
   		if ((keyString == "Return") || (keyString == "Enter"))	// Enter occurs only on Macintosh
   		{
			if (system.event.altKey || system.event.shiftKey || (keyString == "Enter"))
			{
				memo.rejectKeyPress();
				if (system.event.shiftKey) { closeMemoWindow(); } else { saveMemoWindow(); }
			}
		}
	}
